/* This file is part of the Roméo model-checking software

Copyright École Centrale de Nantes, LS2N

Contributors: Didier Lime (2014-2025)

Didier.Lime@ec-nantes.fr

This software is a computer program whose purpose is to perform
parametric model checking on timed and hybrid systems.

This software is governed by the CeCILL license under French law and
abiding by the rules of distribution of free software.  You can  use, 
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info". 

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability. 

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or 
data to be ensured and,  more generally, to use and operate it in the 
same conditions as regards security. 

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms. */

#ifndef ROMEO_AVALUE_HH
#define ROMEO_AVALUE_HH

#include <valuation.hh>
#include <timebounds.hh>
#include <printable.hh>

namespace romeo
{
    class Avalue: public Printable
    {
        private:
            cvalue val;
            char ceps;
            char inf;
            cvalue d;

        public:
            static Avalue infinity;
            static Avalue minus_infinity;

        public:
            Avalue();
            Avalue(cvalue);
            Avalue(cvalue, char);
            Avalue(cvalue, char, char);
            Avalue(cvalue, char, char, cvalue);
            Avalue(const Avalue&);
            Avalue(const time_bound&);

            time_bound tbound() const;
            cvalue value() const;
            cvalue denominator() const;

            bool is_inf() const;
            bool is_minus_inf() const;
            bool is_strict() const;

            void simplify();
            void strictify();

            Avalue operator+(const Avalue&) const;
            Avalue operator-(const Avalue&) const;
            Avalue operator-() const;
            Avalue operator*(const cvalue) const;
            Avalue operator/(const cvalue) const;
            bool operator==(const Avalue&) const;
            bool operator!=(const Avalue&) const;
            Avalue& operator=(const Avalue&);

            std::string to_string() const;

            friend bool operator<(const Avalue&, const Avalue&);
            friend bool operator>(const Avalue&, const Avalue&);
            friend bool operator<=(const Avalue&, const Avalue&);
            friend bool operator>=(const Avalue&, const Avalue&);
    };

    bool operator<(const Avalue&, const Avalue&);
    bool operator>(const Avalue&, const Avalue&);
    bool operator<=(const Avalue&, const Avalue&);
    bool operator>=(const Avalue&, const Avalue&);
}

#endif

