/*----------------------------------------------------------------------
 Programme recupere en 1998 via P. Anelli (alors vacataire  Nantes)
 Modifi pour TP Reseaux  - Attiogb, Faucher, Hamma, Passard
 Salle I19 Nantes - Usage exclusivement pedagoqique (TP Reseaux) 
 --------------------------------------------------------------------- */
#define CONFIG_NET_IPV6_DIM
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <linux/if_ether.h>  /* Protocol Type for Ethernet */
#include <stdlib.h>
#include <netinet/in.h>       /* structure de l'adresse INET */
#include <arpa/inet.h>        /* routines reseaux ntop*/
#include <asm/checksum.h>


char *program_name;
char snoop_device[30];
char eth_add_router[] = "08:00:20:0A:AC:96"; /* address of the default router */
char eth_add_local[18]; /* hw address of this machine */
char ip_add_local[18]; /* ip address of this machine */
extern int errno;
extern char * sys_errlist[];
struct ifreq ifr_orig; /* for interface status storage */

#include <inet_struct.h>
	
void p_error(char *s) {
	fprintf(stderr,"%s: %s ", program_name, s);
	if (errno !=0) {		
		fprintf(stderr,"(%s)",sys_errlist[errno]);
		errno=0;
		}	
	fprintf(stderr,"\n");
} /* perror */
	
/* This version of checksum is a slight modification of the naive implementation
   presented in TCP/IP Illustrated vol2*/
/*  	    
unsigned short checksum( char * buf, int len, unsigned short init)
{	unsigned long int sum;	//32 bits
	sum = init;
	while (len>1) {
		sum += *((unsigned short *) buf)++;
		if (sum & 0x80000000) // high order bit set 
			sum = (sum & 0xFFFF) + (sum>>16);
		len -=2;
	}	
	if (len) // odd byte count
		sum += (unsigned short) * (unsigned char *) buf;
	while (sum >> 16)
		sum = (sum & 0xFFFF) + (sum >> 16);
	return(sum);
}
*/

/* function ip6_addr_ip4 converts a dot notation IP 4 address 
in a compatible IP 6 128 bits address*/
/*
void ip6_addr_ip4( struct in6_addr * a, char * b)
		{	a->s6_addr32[0] = 0;
			a->s6_addr32[1] = 0;
			a->s6_addr16[4] = 0;
			a->s6_addr16[5] = 0; // 0xFFFF
			a->s6_addr32[3] = inet_addr(b);
			} // ip6_addr_ip4

*/
/* function eth_addr converts an ASCII Ethernet address into a 6 bytes format
in network byte order ready to go into an ethernet frame. 
The input format is 00:00:C0:F3:57:6B for example. 
The return value is a pointer to a static variable of the function.*/
/*			
		char *eth_addr(char * a){
			static char result[6]; // the resulting ethernet address 
			char * p; // pointer for string analysis 
			int i,j;
			char  adr[18],conv[10], * ad = adr;
			if (strlen(a) != 17) { // address too short 
			p_error("eth_addr: bad address");
			return(NULL);
			}
			strncpy(ad, a, 17);ad[17]=':';
			for (i=0, p=ad; i<6; i++) {
			p = strchr(ad,':'); p++;
			if ((ad + 3) != p) {
			p_error("eth_addr: bad octet in address");
			return(NULL);}
			strcpy(conv,"0x");
			strncat(conv,ad,2); sscanf(conv,"%x",&j);
			result[i] = j;
			ad = p;
			}
			return(result);
			} // eth_addr 
			
			char *eth_type(char *a)
			{
			static char result[2]; // the resulting ethernet type 
			char conv[10];
			int j;
			if (strlen(a) != 4) { // address too short 
			p_error("eth_type: bad number");
			return(NULL);
			}
			strcpy(conv,"0x");strncat(conv,a,2);sscanf(conv,"%x",&j);
			result[0]=j;
			strcpy(conv,"0x");strncat(conv,a+2,2);sscanf(conv,"%x",&j);
			result[1]=j;
			return(result);}
			
*/			
			
void restore_interface() {	
	int fd; // file descriptor for interface access
	fd = socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL));
	if (fd < 0) {
		p_error("socket - could not restore interface to normal state");
		return;
	}
	if (ioctl(fd, SIOCSIFFLAGS, &ifr_orig) < 0) {
		p_error("ioctl - could not restore interface to normal state");
		return;
	}
} // restore_interface 


int open_interface(char *device){
   int fd; /* file descripor for interface access */
   struct ifreq ifr; /* parameter for ioctl */
				
   fd =  socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL));
   if (fd < 0) {
	p_error("socket - could not open interface");
	return(-1);
   }
   if (strncmp(device, "eth", 3) != 0) {
	p_error("only eth devices supported");
	return(-1);
   }
   strcpy(ifr.ifr_name, device); /* the device to be used */
   if (ioctl(fd, SIOCGIFFLAGS, &ifr) < 0) {
      p_error("could not get interface flags");
      return(-1);
   }

   ifr_orig = ifr;
   atexit(restore_interface); /* for cleaning at program end */
   ifr.ifr_flags |= IFF_PROMISC; /* set promiscuous mode */
   if (ioctl(fd, SIOCSIFFLAGS, &ifr) < 0) {
		p_error("ioctl - could set promiscuous mode");
		return(-1);
   }
   strcpy(snoop_device, device);
   return(fd);
} /* open_interface */
		
void dump_hex(char * buf, int nb) {
  int i=0, n=0;
  for ( ; nb>0; nb--) {
    printf("%02hx ", (unsigned char) buf[i]); i++; n++;
    if (n == 16) {
	printf("\n"); n = 0;
    }
  }
  if (n != 0) {
     printf("\n");
  }
} /* dump_hex */

/* function read_eth_frame
This function reads an ethernet frame of type type.
For example, if type == htons(0x0806), 
ARP frames are read 0x0800 , 
IP frames are read
The number of bytes read is returned in n
*/

struct eth_frame * read_eth_frame(int fd, unsigned short int type, int *n)
{ int nb; /* number of bytes read */
  struct sockaddr from; /* address from which the packet is coming */
  int from_len; /* length of the address */
  static struct eth_frame buf; /* buffer for data transfer */
  do {
    nb =  recvfrom( fd, &buf, sizeof(buf), 0, &from, &from_len);
  } while (memcmp(buf.type, &type, 2) != 0);
  *n = nb;
  return(&buf);
} /* read_eth_frame */


/*
struct eth_frame * read_ip_frame(int fd, unsigned short int type, int * n)
{
  int nb; // number of bytes read 
  struct sockaddr from; // address from which the packet is coming
  int from_len; // length of the address
  static struct eth_frame buf; // buffer for data transfer
  struct ip4_frame *ip;

  do {
     nb =  recvfrom( fd, &buf, sizeof(buf), 0, &from, &from_len);
     ip = (struct ip4_frame *) buf.data;
  } while (ip->protocol != type);

  *n = nb;
  return(&buf);
} // read_ip_frame 
		
*/		
char * get_eth_addr(int fd) {
	struct ifreq ifr;
	static char result[18];
	unsigned char *p;
		
	strcpy(ifr.ifr_name, snoop_device); /* the device to be used */
	if (ioctl(fd,SIOCGIFHWADDR, &ifr) <0 ) {
		p_error("get_eth_addr - error");
	}
	p = (unsigned char *) ifr.ifr_hwaddr.sa_data;
	sprintf(result,"%02x:%02x:%02x:%02x:%02x:%02x",
			p[0],p[1],p[2],p[3],p[4],p[5]);
	result[17]='\0';
	return(result);
} /* get_eth_addr */
		
char * get_ip_addr(int fd){
	struct ifreq ifr;
	static char result[18];
	unsigned char *p;
	int res;
		
	strcpy(ifr.ifr_name, snoop_device); /* the device to be used */
	if ((res=ioctl(fd, SIOCGIFADDR, &ifr)) <0 ) {
		p_error("get_ip_addr - error");
	}
	p = (unsigned char *) ifr.ifr_addr.sa_data; p+=2;
		
	sprintf(result,"%d.%d.%d.%d\n",
			p[0],p[1],p[2],p[3]);
	return(result);
} /* get_ip_addr */
		
		
void main(int argc, char **argv) {
		//char line [INET6_ADDRSTRLEN];
		char * cp;
		int nb;
		char * device = "eth0"; /* device to read by default */
		int fd ; /* descriptor to read from */
		struct eth_frame f, *g; /* ethernet frames */
		struct ip6_frame * ip6;
		struct ip4_frame * ip;
		unsigned int nbpacket = 0;
		
	if ((cp = strrchr(argv[0],'/')) != NULL)
		program_name = cp + 1;
	else
		program_name = argv[0];
	fd = open_interface(device);
	fprintf(stderr,"%s: hardware address: %s IP address: %s device: %s\n",
		program_name,get_eth_addr(fd), get_ip_addr(fd), device);
	strcpy(eth_add_local, get_eth_addr(fd)); /* local ethernet address */
	strcpy(ip_add_local, get_ip_addr(fd)); /* local ip address */
	while (1) {
		g=read_eth_frame(fd, 0x0008, &nb);
		ip = (struct ip4_frame *) g->data;
		if ((ip->protocol == 0x11) &&
		   ((((struct udp_frame *) ip->data)->port_src == 0xA100) ||
		   (((struct udp_frame *) ip->data)->port_dst == 0xA100)))  {
		 
//			 printf("\n---------------------------------------------------------------------\nPacket No: %i\n", nbpacket++);
//		 	printf("Byte rcv      : %d\n", nb);
		 	dump_hex((char *)g, 90); 
		 	continue;
		}
		if ((ip->protocol == 0x01) &&
		        ((((struct icmp4_echo_req_frame*) ip->data)->type == 0X08) ||
		        	            (((struct icmp4_echo_req_frame*) ip->data)->type == 0X00))) {
//			printf("\n---------------------------------------------------------------------\nPacket No: %i\n", nbpacket++);
//		        	            printf("Byte rcv      : %d\n", nb);
		  	dump_hex((char *)g, 90);
		  	continue;
		}
		if ((ip->protocol ==IPPROTO_TCP)) {
		  
//		  printf("\n---------------------------------------------------------------------\nPacket No: %i\n", nbpacket++);
//		  printf("Byte rcv      : %d\n", nb);
		  dump_hex((char *)g, 90);
		  continue;
		}
	} /*while */
} /* main */
		  
